// packethelper.cpp ackmed@gotwalls.com
#include <windows.h>
#include "packethelper.h"
#include "shopbot.h"

BOOL TakePortal(DWORD wpEntityID) {
	InteractWithEntity(2,wpEntityID);
	InteractWithEntity(2,wpEntityID);
	return true;
}

BOOL TakeWayPoint(DWORD wpEntityID, DWORD Dest) {

	// first interact with entity
	InteractWithEntity(2,wpEntityID);
	BYTE packet[9];
	packet[0] = 0x49;
	memcpy(&packet[1],&wpEntityID,4);
	memcpy(&packet[5],&Dest,4);
	server->GameSendPacketToServer(packet,9);
	return true;
}


BOOL InteractWithEntity(DWORD type,DWORD EntityID) {
	
	BYTE packet[9];
	packet[0] = 0x13;
	memcpy(&packet[1],&type,4);
	memcpy(&packet[5],&EntityID,4);
	server->GameSendPacketToServer(packet,9);
	return true;

}

BOOL StopInteractWithEntity(DWORD type,DWORD EntityID) {

	BYTE packet[9];
	packet[0] = 0x30;
	memcpy(&packet[1],&type,4);
	memcpy(&packet[5],&EntityID,4);
	server->GameSendPacketToServer(packet,9);
	return true;
}

BOOL TakeStep(WORD x, WORD y) {
	
	BYTE packet[5];
	packet[0] = 0x03;
	memcpy(&packet[1],&x,2);
	memcpy(&packet[3],&y,2);
	server->GameSendPacketToServer(packet,5);
	return true;
}

BOOL OpenStore( DWORD npcID,WORD x, WORD y) {
	
	
	BYTE packet[17];
	packet[0] = 0x59;
	packet[1] = 0x01;
	packet[2] = packet[3] = packet[4] = 0;
	memcpy(&packet[5],&npcID,4);
	memcpy(&packet[9],&x,2);
	packet[11] = packet[12] = 0x00;
	memcpy(&packet[13],&y,2);
	packet[15] = packet[16] = 0x00;
	server->GameSendPacketToServer(packet,17);

	InteractWithEntity(1,npcID);
	
	packet[0] = 0x2f;
	packet[1] = 0x01;
	packet[2] = packet[3] = packet[4] = 0;
	memcpy(&packet[5],&npcID,4);
	server->GameSendPacketToServer(packet,9);

	packet[0] = 0x38;
	packet[1] = 0x01;
	packet[2] = packet[3] = packet[4] = 0;
	memcpy(&packet[5],&npcID,4);
	packet[9] = packet[10] = packet[11] = packet[12] = 0;
	server->GameSendPacketToServer(packet,13);

	return true;
}

// from berto
BOOL BuyItem(DWORD itemID, DWORD npcID) {
	BYTE packet[17];
	packet[0] = 0x32;
	memcpy(&packet[1],&npcID,4);
	memcpy(&packet[5],&itemID,4);
	packet[9] = 0x00;
	packet[10] = 0x00;
	packet[11] = 0x00;
	packet[12] = 0x00;
	packet[13] = 0x00;
	packet[14] = 0x00;
	packet[15] = 0x00;
	packet[16] = 0x00;
	server->GameSendPacketToServer(packet,17);
	return true;
}

BOOL CloseStore(DWORD npcID) {
	StopInteractWithEntity(1,npcID);
	return(StopInteractWithEntity(1,npcID)); // YES do it twice.
}


// forces the client view to goto x, y
// type
//		0 = hard cut to the location
//		1 = fadded cut to location (like when taking a waypoint)


BOOL ForceClientViewLocation(WORD x, WORD y, BYTE type) {
	BYTE packet[11];

	packet[0] = 0x15;
	packet[1] = 0x00;
	packet[2] = 0x01;
	packet[3] = packet[4] = packet[5] = 0x00;
	memcpy(&packet[6],&x,2);
	memcpy(&packet[8],&y,2);
	packet[10] = type;

	server->GameSendPacketToGame(packet,11);
	return true;
}

// sends the sound message that are trigged by the number pad
BOOL SendSoundToServer(WORD sndID) {
	BYTE packet[3];

	packet[0] = 0x3f;
	memcpy(&packet[1],&sndID,2);
	server->GameSendPacketToServer(packet,3);

	return true;
}

// fakes a sound message from another player or self
BOOL SendSoundToClient(DWORD pID, WORD sndID) {
	BYTE packet[8];

	packet[0] = 0x2c;
	packet[1] = 0x00;
	memcpy(&packet[2],&pID,4);
	memcpy(&packet[6],&sndID,2);
	server->GameSendPacketToGame(packet,8);
	return true;

}